require( "quest/mg_chickenchorus/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

round_num = 
{
	6, -- round one
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(1) + SECONDS(0) + SECONDS(5)*level;
end

initial_setup = true;
cheat = false; -- set to 'true' for testing without finding all chickens
activity_setup = false;
local continueLocation = nil;
show_activity_text = false;

lyricbarY = 450;
lyricbarX = 130;
lyricbarXSpacing = 85;

lyricBarInfo = 
{
	-- 7 notes in bar
	-- note 1
	{
		offset = { x = lyricbarX+(0*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 2
	{
		offset = { x = lyricbarX+(1*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 3
	{
		offset = { x = lyricbarX+(2*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 4
	{
		offset = { x = lyricbarX+(3*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 5
	{
		offset = { x = lyricbarX+(4*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 6
	{
		offset = { x = lyricbarX+(5*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		nest = nil;
		correct = false;
	};
	-- note 7
	{
		offset = { x = lyricbarX+(6*lyricbarXSpacing), y = lyricbarY };
		chicken1 = nil;
		chicken2 = nil;
		questionMark = nil;
		nest = nil;
		correct = false;
	};
};

-- which chicken has which note
note2chicken = 
{
	1,
	2,
	5,
	6,
	3,
	4,
	7,
	8
}

song_table = 
{
	-- round 1
	{ 
		-- song 1
		{
			title = "Mary Had A Little Lamb";
			numNotes = 7;
			notes = { 3, 2, 1, 2, 3, 3, 3 };
			lyrics = 
			{ 
				
			};
		};

		-- song 2
		{
			title = "I Had Salami For Lunch";
			numNotes = 7;
			notes = { 1, 3, 5, 8, 5, 3, 1 };
			lyrics = 
			{ 
				
			};
		};

		-- song 3
		{
			title = "";
			numNotes = 7;
			notes = { 8, 6, 7, 5, 7, 6, 8 };
			lyrics = 
			{ 
				
			};
		};

		-- song 4
		{
			title = "Twinkle Twinkle Little Star";
			numNotes = 14;
			notes = { 1, 1, 5, 5, 6, 6, 5, 4, 4, 3, 3, 2, 2, 1 };
			lyrics = 
			{ 

			};
		};	
		


		-- song 5
		{
			title = "Old MacDonald Had A Farm";
			numNotes = 12;
			notes = { 5, 5, 5, 2, 3, 3, 2, 7, 7, 6, 6, 5 };
			lyrics = 
			{ 

			};
		};


		-- song 6
		{
			title = "America the Beautiful";
			numNotes = 14;
			notes = { 5, 5, 3, 3, 5, 5, 2, 2, 3, 4, 5, 6, 7, 5 };
			lyrics = 
			{ 

			};
		};


	},
	
	-- activity mode
	{ 
		
		-- song 1
		{
			title = "untitled";
			numNotes = 7;
			notes = { 8, 7, 6, 5, 1, 2, 3 };
			lyrics = 
			{ 
				
			};
		};
		
		-- song 2
		{
			title = "untitled";
			numNotes = 7;
			notes = { 5, 5, 3, 6, 5, 5, 3 };
			lyrics = 
			{ 

			};
		};
		-- song 3
		{
			title = "untitled";
			numNotes = 7;
			notes = { 1, 3, 2, 4, 1, 3, 1 };
			lyrics = 
			{ 

			};
		};

		-- song 4
		{
			title = "I Had Salami For Lunch";
			numNotes = 9;
			notes = { 1, 3, 5, 8, 5, 3, 1, 2, 1 };
			lyrics = 
			{ 
				
			};
		};

		-- song 5
		{
			title = "mary had a little lamb";
			numNotes = 13;
			notes = { 3, 2, 1, 2, 3, 3, 3, 2, 2, 2, 3, 5, 5 };
			lyrics = 
			{ 

			};
		};

		-- song 6
		{
			title = "Row Row Row Your Boat";
			numNotes = 10;
			notes = { 1, 1, 1, 2, 3, 3, 2, 3, 4, 5 };
			lyrics = 
			{ 
				
			};
		};

		-- song 7
		{
			title = "untitled";
			numNotes = 10;
			notes = { 1, 3, 2, 1, 5, 4, 1, 8, 7, 8};
			lyrics = 
			{ 

			};
		};

		-- song 8
		{
			title = "rockabye baby";
			numNotes = 9;
			notes = { 1, 3, 6, 5, 3, 1, 3, 5, 4 };
			lyrics = 
			{ 
				
			};
		};

		
		-- song 9
		{
			title = "";
			numNotes = 12;
			notes = { 6, 7, 6, 5, 6, 7, 6, 8, 6, 7, 6, 5 };
			lyrics = 
			{ 

			};
		};

		-- song 10
		{
			title = "untitled";
			numNotes = 11;
			notes = { 1, 3, 5, 5, 5, 5, 4, 3, 1, 2, 3};
			lyrics = 
			{ 

			};
		};

		-- song 11
		{
			title = "london bridge";
			numNotes = 13;
			notes = { 5, 6, 5, 4, 3, 4, 5, 2, 3, 4, 3, 4, 5 };
			lyrics = 
			{ 

			};
		};	
		
		-- song 12
		{
			title = "untitled";
			numNotes = 13;
			notes = { 5, 5, 3, 6, 5, 5, 3, 6, 5, 5, 6, 7, 8 };
			lyrics = 
			{ 

			};
		};


		-- song 13
		{
			title = "bingo";
			numNotes = 15;
			notes = { 1, 4, 4, 4, 1, 2, 2, 1, 1, 4, 4, 5, 5, 6, 4 };
			lyrics = 
			{ 

			};
		};

		-- song 14
		{
			title = "untitled";
			numNotes = 13;
			notes = { 5, 5, 6, 8, 8, 7, 6, 5, 1, 1, 2, 3, 1};
			lyrics = 
			{ 

			};
		};

		

		-- song 15
		{
			title = "farmer in the dell";
			numNotes = 13;
			notes = { 1, 4, 4, 4, 5, 6, 6, 6, 8, 8, 8, 6, 4 };
			lyrics = 
			{ 

			};
		};


	
		-- song 17
		{
			title = "untitled";
			numNotes = 16;
			notes = { 6, 6, 7, 7, 2, 3, 2, 3, 8, 8, 5, 5, 1, 4, 1, 1 };
			lyrics = 
			{ 

			};
		};



	},
};

sounds = 
{
	"audio/sfx/chicken_cluck1.ogg",
	"audio/sfx/chicken_cluck2.ogg",
	"audio/sfx/chicken_cluck3.ogg",
	"audio/sfx/chicken_cluck4.ogg",
	"audio/sfx/chicken_cluck5.ogg",
	"audio/sfx/chicken_cluck6.ogg",
	"audio/sfx/chicken_cluck7.ogg",
	"audio/sfx/chicken_cluck8.ogg",
};

COLOR_RED = { a = 1, r = 0.86, g = 0.07, b = 0.07 };
COLOR_GREEN = { a = 1, r = 0.23, g = 0.6, b = 0.23 };
COLOR_BLUE = { a = 1, r = 0.01, g = 0.35, b = 0.85 };
COLOR_YELLOW = { a = 1, r = 0.95, g = 0.71, b = 0.15 };
COLOR_PURPLE = { a = 1, r = 0.5, g = 0.22, b = 0.78 };
COLOR_CYAN = { a = 1, r = 0.47, g = 0.82, b = 0.82 };
COLOR_BROWN = { a = 1, r = 0.67, g = 0.54, b = 0.23 };
COLOR_TAN = { a = 1, r = .81, g = 0.73, b = 0.55 };

chicken_table = 
{
	{ number = 1, note = 1, x = 50, y = 190, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED, scale = { x = 1, y = 1}, nest = 1, },
	{ number = 1, note = 2, x = 190, y = 225, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN, scale = { x = 1, y = 1}, nest = 2},
	{ number = 2, note = 5, x = 80, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED, scale = { x = 1, y = 1}, nest = 3},
	{ number = 2, note = 6, x = 215, y = 340, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN, scale = { x = 1, y = 1}, nest = 4},
	
	{ number = 1, note = 3, x = 610, y = 225, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED, scale = { x = -1, y = 1}, nest = 5},	
	{ number = 1, note = 4, x = 750, y = 190, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_BLUE, scale = { x = -1, y = 1}, nest = 6},
	{ number = 2, note = 7, x = 600, y = 340, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN, scale = { x = -1, y = 1}, nest = 7},
	{ number = 2, note = 8, x = 740, y = 295, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED, scale = { x = -1, y = 1}, nest = 8},
};

chickenItems = 
{
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
	{ 
		item = nil;
		animationTime = 0;
	};
};

smallChickenInfo1 = { number = 1, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED, nest = -1 };
smallChickenInfo2 = { number = 2, x = 100, y = 200, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED, nest = -1 };

henInfo = 
{
	offset = { x = 0, y = 0 };
	image = "red_hen";
	highlight = "red_hen_highlight";
	stop = "red_hen";
	stopHighlight = "red_hen_highlight";
};

nestInfo = 
{
	offset = { x = -75, y = -40 };
	image = "nest_large";
};

eggInfo = 
{
	offset = { x = -20, y = -50 }; --{ x = 470, y = 300 };
};

henTalkInfo = 
{
	offset = { x = 250, y = 250 };
	image = "";
};

comeBackTalkInfo = 
{
	offset = { x = 210, y = 415 };
	offsetInactive = { x = 900, y = 700 };
	image = "go_to_field_button";
}

highlightInfo = 
{
	image = "egg_highlight";
};

errorHighlightInfo = 
{
	image = "error_highlight";
};

eggTextInfo = 
{
	offset = { x = 55, y = 390 };
	play = ""; --"Play\nSong";
	stop = ""; --"Stop\nSong";
	highlight = "egg_button_highlight";
	button = "egg_button";
	stop_highlight = "egg_button_stop_highlight";
	stop_button = "egg_button_stop";
};

henTalkItem = nil;
comeBackTalkItem = nil;
eggTextItem = nil;

eggPickup = nil;

local songPlaying = false;
local startDelay = 15;
local mistake = false;
local note = 1;
local highlight = nil;
local errorHighlight = nil;
local hen = nil;
local henAnimTime = 0;
local nextNote = 1;
local passed = false;
local globalFlo = nil;
local comeBack = false;
local celebrating = false;
local transition = true;

local CHICKEN_FLAP_TIME = 15;
local next_activity_pressed = false;

function request_song(activityNum)
	scene.FLO:SetMode(MODE.CUTSCENE);
	delay(15);
	if game:Get("activity_mode") ~= 1 then
		run_super_conversation( scene.FLO, "conv_song_" .. activityNum );	
	else
		run_super_conversation( scene.FLO, "conv_song_activity_mode" );	
	end
	--henTalkItem:SayRaw( scene:grabstring( "conv_song_" .. game:Get("mg_chickenchorus_activity_num") ) );	
	delay(15);
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function start_song()		
	for i = 1, 8 do
		Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
		chickenItems[i].animationTime = 0;
	end
	note = 1;
	songPlaying = true;
	startDelay = 15;
end

function updateLyricBar( round, song, note )
	local startNote = math.floor( ( note - 1 ) / 7 ) * 7;
	for i = 1, 7 do		
		lyricBarInfo[i].nest:SetAlpha( 1 );		
		if ( ( startNote + i < nextNote ) and lyricBarInfo[i].correct == true ) then
			Chicken_SetAlpha( lyricBarInfo[i].chicken1, 0 );
			Chicken_SetAlpha( lyricBarInfo[i].chicken2, 0 );
			lyricBarInfo[i].questionMark:SetAlpha( 0 );
			local chickenIndex = note2chicken[song_table[round][song].notes[startNote + i]];
			if ( chicken_table[chickenIndex].number == 1 ) then
				ColourChicken( lyricBarInfo[i].chicken1, chicken_table[chickenIndex] );
				Chicken_SetAlpha( lyricBarInfo[i].chicken1, 1 );
			else
				ColourChicken( lyricBarInfo[i].chicken2, chicken_table[chickenIndex] );
				Chicken_SetAlpha( lyricBarInfo[i].chicken2, 1 );
			end
			lyricBarInfo[i].nest:ModifySaySpec
			{
				color = { a = 1, r = 1, g = 1, b = 1 },
			};
		else
			Chicken_SetAlpha( lyricBarInfo[i].chicken1, 0 );
			Chicken_SetAlpha( lyricBarInfo[i].chicken2, 0 );
			lyricBarInfo[i].questionMark:SetAlpha( 1 );
			lyricBarInfo[i].nest:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
			};
		end
		if ( startNote + i > song_table[round][song].numNotes ) then
			lyricBarInfo[i].questionMark:SetAlpha( 0 );
			lyricBarInfo[i].nest:SetAlpha( 0 );
		end
		if ( songPlaying == true and note == startNote + i ) then
			lyricBarInfo[i].nest:ModifySaySpec
			{
				color = { a = 1, r = 1, g = 1, b = 1 },
			};
		else
			lyricBarInfo[i].nest:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
			};
		end
		--lyricBarInfo[i].nest:SayRaw( song_table[round][song].lyrics[startNote + i] );
	end
	if ( songPlaying == false ) then
		local noteIndex = GetNoteIndex( nextNote );
		local offset = { x = lyricBarInfo[noteIndex].offset.x, y = lyricBarInfo[noteIndex].offset.y - 50 };
		highlight:JumpToPoint( offset );
		highlight:SetAlpha( 1 );
	else
		highlight:SetAlpha( 0 );
	end
	if ( nextNote > song_table[round][song].numNotes ) then
		passed = true;
		highlight:SetAlpha( 0 );
	end
end

function spawn_lyricBar()
	for i = 1, 7 do
		-- spawn nests
		lyricBarInfo[i].nest = scene:Spawn( get_object_spec( "lyricbar" .. tostring(i), "nest_small", lyricBarInfo[i].offset, 500 ) );
		lyricBarInfo[i].nest:SetAlpha( 0 );
		
		--spawn chickens
		local offset = { x = lyricBarInfo[i].offset.x + 45, y = lyricBarInfo[i].offset.y + 25 };
		lyricBarInfo[i].chicken1 = spawnSmallChicken( i + 8, smallChickenInfo1, offset );
		lyricBarInfo[i].chicken2 = spawnSmallChicken( i + 15, smallChickenInfo2, offset );
		lyricBarInfo[i].chicken1:DumpZone();
		lyricBarInfo[i].chicken2:DumpZone();
		lyricBarInfo[i].questionMark = scene:Spawn( get_object_spec( "questionMark" .. tostring(i), "questionMark", { x = lyricBarInfo[i].offset.x - 5, y = lyricBarInfo[i].offset.y - 50 } ) );
		lyricBarInfo[i].questionMark:SetAlpha( 0 );
	end	
	highlight = scene:Spawn( get_object_spec( "highlight", highlightInfo.image, lyricBarInfo[1].offset ) );	
	highlight:SetAlpha( 0 );
	highlight:SetDepthValue( 0 );	
	errorHighlight = scene:Spawn( get_object_spec( "errorHighlight", errorHighlightInfo.image, lyricBarInfo[1].offset ) );
	errorHighlight:SetAlpha( 0 );
	errorHighlight:SetDepthValue( 0 );
end

function spawnSmallChicken( index, data, offset )
	local chicken_skeleton = scene:Spawn(get_chicken_spec(index, data));
	local chicken_wings = scene:Spawn(get_chicken_wings_spec(index, data));
	local chicken_body = scene:Spawn(get_chicken_body_spec(index, data));
	local chicken_belly = scene:Spawn(get_chicken_belly_spec(index, data));
	local chicken_tail = scene:Spawn(get_chicken_tail_spec(index, data));
	
	chicken_skeleton.children = { };
	table.insert(chicken_skeleton.children, chicken_wings);
	table.insert(chicken_skeleton.children, chicken_body);
	table.insert(chicken_skeleton.children, chicken_belly);
	table.insert(chicken_skeleton.children, chicken_tail);
		
	chicken_skeleton:FaceNow(DIR.E);
	chicken_skeleton:JumpToPoint( offset );
	
	for i,v in pairs(chicken_skeleton.children) do
		v:FaceNow(DIR.E)
		v:JumpToPoint( offset );
	end
	
	Chicken_PlayAnim( chicken_skeleton, "NoMove" );
	Chicken_SetScale( chicken_skeleton, 0.65 );
	Chicken_SetAlpha( chicken_skeleton, 0 );
	return chicken_skeleton;
end

function spawn_chickens()
	for i,v in chicken_table do
		
		local chicken_skeleton = scene:Spawn(get_chicken_spec(i, v));
		local chicken_wings = scene:Spawn(get_chicken_wings_spec(i, v));
		local chicken_body = scene:Spawn(get_chicken_body_spec(i, v));
		local chicken_belly = scene:Spawn(get_chicken_belly_spec(i, v));
		local chicken_tail = scene:Spawn(get_chicken_tail_spec(i, v));
		
		
		chicken_skeleton.children = { };
		table.insert(chicken_skeleton.children, chicken_wings);
		table.insert(chicken_skeleton.children, chicken_body);
		table.insert(chicken_skeleton.children, chicken_belly);
		table.insert(chicken_skeleton.children, chicken_tail);
		
		chicken_skeleton:FaceNow(DIR.E);
		
		for i,v in pairs(chicken_skeleton.children) do
			v:FaceNow(DIR.E)
		end
		
		chickenItems[i].item = chicken_skeleton;
		
		Chicken_PlayAnim( chicken_skeleton, "NoMove" );		
		
		--scene:Spawn( get_object_spec( "nest" .. tostring(i), nestInfo.image, { x = v.x + nestInfo.offset.x, y = v.y + nestInfo.offset.y } ) );
	end
end

function get_henTalk_spec( _name, _image, _offset )
return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(3);
			actor:JumpToPoint( _offset );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEVFLIP + BUBBLE.BUBBLE_FORCEFLIP,
				bubble_mouth = { x = 243, y = 190 };
				outline_size = 0,
				font = "fonts/dom_casual_std.mvec",
				anchor = ANCHOR.CENTER
			};
		end;
	}
end

function get_comeBackTalk_spec( _name, _image, _offset )
return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image .. "_up" };
	
		command = function(actor)
			actor:SetDepthValue(550);
			actor:JumpToPoint( _offset );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				bubble = false,
				y = 32,
				x = 0,
				w = 385,
				h = 65,
				outline_size = 0,
				lineheight = 26;
				font = "fonts/dom_casual_std.mvec",
				anchor = ANCHOR.CENTER
			};
			actor:Say( "text_goto_chicken_fields" );
		end;
		
		on_click = function(flo, actor)
			actor:LoadImage(_image .. "_down");
			goto_scene(flo, "mg_chickenfield");	
		end;		
			
		point_at_fn = function(actor, enter)
			if enter then
				actor:LoadImage(_image .. "_over");
				actor:Say( "text_goto_chicken_fields" );
			else
				actor:LoadImage(_image .. "_up");
				actor:Say( "text_goto_chicken_fields" );
			end
		end;
	}
end

function get_object_spec( _name, _image, _offset, _depth )
return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
	
		command = function(actor)
			if _depth then
				actor:SetDepthValue(_depth);
			else
				actor:SetDepthValue(3);
			end
			actor:JumpToPoint( _offset );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);	
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				bubble = false,
				x = -160;
				y = 45;
				outline_size = 0,
				font = "fonts/dom_casual_std.mvec",
				anchor = ANCHOR.CENTER
			};			
		end;
	}
end

function Chicken_PlayAnim( chicken, anim )
	chicken:PlayAnim( anim );
	for i,v in pairs(chicken.children) do
		v:PlayAnim( anim );
	end
end

function Chicken_SetScale( chicken, scale )
	chicken:SetScale( scale );
	for i,v in pairs(chicken.children) do
		v:SetScale( scale );
	end
end

function Chicken_SetAlpha( chicken, alpha )
	chicken:SetAlpha( alpha );
	for i,v in pairs(chicken.children) do
		v:SetAlpha( alpha );
	end
end

function spawn_hen()
	hen = scene:Spawn( get_hen_spec( "HEN", henInfo.image, henInfo.offset ) );	
	henTalkItem = scene:Spawn( get_henTalk_spec( "henTalk", henTalkInfo.image, henTalkInfo.offset ) );
	if GetNumChickensFound() == 8 then
		eggTextItem = scene:Spawn( get_eggText_spec( "eggText", eggTextInfo.button, eggTextInfo.offset ) );
	else
		for i = 1, 8 do
			chickenItems[i].item:DumpZone();
		end
	end
	--eggTextItem:SayRaw( eggTextInfo.play );
	eggPickup = scene:Spawn( get_egg_spec( "egg", { x = -500, y = -500 } ) );	
	HideEgg();
end

egg_anim_table = 
{ 
	"anim/mg_chickenchorus/egg_anim",	
};

function get_egg_spec( _name, _offset )
return
	{
		name = _name;
		--halo = _name;
		gfx = { anim = egg_anim_table, image = _name };
	
		command = function(actor)
			actor:SetDepthValue(203);
			actor:JumpToPoint( _offset );
			actor:SetPointAtCursor("cursor");
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetAlpha(0);			
		end;
		
		on_click = function(flo, actor)
			if ( celebrating == false and next_activity_pressed == false ) then	
				HideEgg();
				flo:StartProc(GetEgg);
			end
		end;				
	}
end

function HideContinue()
	if game:Get("activity_mode") ~= 1 then
		scene.NEXT_ACTIVITY_BUTTON:JumpToPoint( { x = -100, y = -100 } );
		scene.NEXT_ACTIVITY_BUTTON:SetAlpha( 0 );
		scene.NEXT_ACTIVITY_BUTTON:SayRaw( "" );
	end
end

function ShowContinue()
	if game:Get("activity_mode") ~= 1 then
		scene.NEXT_ACTIVITY_BUTTON:JumpToPoint( continueLocation );
		scene.NEXT_ACTIVITY_BUTTON:SayRaw( scene:grabstring( "continue" ) );
		scene.NEXT_ACTIVITY_BUTTON:SetAlpha( 1 );
	end
end

function GetEgg( actor )
	actor:SetMode(MODE.CUTSCENE);	
	scene.HELP_PANEL:SetAlpha( 0 );
	help_panel_say_raw( "" );
	HideContinue();
	local activityNum = game:Get("mg_chickenchorus_activity_num") - 1;
	local egg_count = game:Get("egg_count");
	if egg_count < 1 then
		egg_count = 1;
	else
		egg_count = egg_count + 1;
	end
	game:Set( "egg_count", egg_count );
	addInventory( inv_desc_egg );
	BAG_INV:SetInventoryOvertextFlags("egg", kHAlignCenter + kVAlignTop);
	BAG_INV:SetInventoryOvertext("egg", egg_count .. " / 6" );
	help_panel_say_raw( scene:grabstring("activity_complete_" .. tostring( game:Get( "mg_chickenchorus_activity_round" ) ) .. "_" .. tostring( activityNum ) ) );
	scene.HELP_PANEL:SetAlpha( 1 );	
	actor:SetMode(MODE.FOLLOWCLICKS);
end

function ShowEgg()
	eggPickup:JumpToPoint( eggInfo.offset );
	eggPickup:SetAlpha( 1 );
	sfx:PlaySFX("audio/sfx/hen_egg");
	eggPickup:PlayAnim( "Egg" );
end

function HideEgg()
	eggPickup:JumpToPoint( { x = -500, y = -500 } );
	eggPickup:SetAlpha( 0 );
end

hen_anim_table = 
{ 
	"anim/mg_chickenchorus/hen_happy", 
	"anim/mg_chickenchorus/hen_unhappy", 	
	"anim/mg_chickenchorus/talk",	
};

function get_hen_spec( _name, _image, _offset )
return
	{
		name = _name;
		--halo = _image;
		gfx = { anim = hen_anim_table, image = _image };
	
		command = function(actor)
			prepare_actor_text(actor, hen_text_spec);
			actor:SetDepthValue(1);
			actor:JumpToPoint( _offset );
			
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:Face(DIR.W);
		end;
	}
end

function stop_song()
	--eggTextItem:LoadImage( eggTextInfo.button );
	--eggTextItem:SayRaw( eggTextInfo.play );
	songPlaying = false;
	local round = game:Get("mg_chickenchorus_activity_round");
	local song = game:Get("mg_chickenchorus_activity_num");
	updateLyricBar( round, song, 1 );	
	
	for i = 1, 8 do
		local nest = chickenItems[i].item.chicken_data.nest;
		scene["NEST_OVERLAY" .. nest]:LoadImage("Nest_overlay" .. nest);
	end
end

function get_eggText_spec( _name, _image, _offset )
return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(204);
			actor:JumpToPoint( _offset );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);	
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				bubble = false,
				x = -160;
				y = 81;
				outline_size = 0,
				font = "fonts/dom_casual_std.mvec",
				anchor = ANCHOR.CENTER
			};
			eggTextInfo.play = scene:grabstring("play_song");
			eggTextInfo.stop = scene:grabstring("stop_song");
		end;
		
		on_click = function(flo, actor)
			if ( game:Get("mg_chickenchorus_activity_round") == 1 ) then
				if ( songPlaying == false and mistake == false and comeBack == false and celebrating == false and transition == false ) then
					eggTextItem:LoadImage( eggTextInfo.stop_highlight );
					--eggTextItem:SayRaw( eggTextInfo.stop );
					start_song();					
				elseif ( songPlaying == true ) then
					eggTextItem:LoadImage( eggTextInfo.highlight );
					--eggTextItem:SayRaw( eggTextInfo.play );
					stop_song();					
				end			
			end
		end;		
		
		point_at_fn = function(actor, enter)
			if ( game:Get("mg_chickenchorus_activity_round") == 1 ) then
				if ( songPlaying == false and mistake == false and comeBack == false and celebrating == false and transition == false ) then
					if enter then
						eggTextItem:LoadImage( eggTextInfo.highlight );
						--eggTextItem:SayRaw( eggTextInfo.play );
					else
						eggTextItem:LoadImage( eggTextInfo.button );
						--eggTextItem:SayRaw( eggTextInfo.play );
					end
				elseif ( songPlaying == true ) then
					if enter then
						eggTextItem:LoadImage( eggTextInfo.stop_highlight );
						--eggTextItem:SayRaw( eggTextInfo.stop );
					else
						eggTextItem:LoadImage( eggTextInfo.stop_button );
						--eggTextItem:SayRaw( eggTextInfo.stop );
					end
				end
			end
		end;
	}
end

function get_chicken_spec(num, chicken_data)
	return 
	{
		name = "CHICKEN_" .. num;
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_skeleton" };
		halo = "chicken" .. chicken_data.number;
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
			actor:SetDepthValue(chicken_data.y);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetWalkSpeed(chicken_speed);
			prepare_actor_text(actor);
			actor.direction = DIR.E;
			actor.note = chicken_data.note;
			
			if chicken_data.scale then
				actor:SetScaleX(chicken_data.scale.x);
			end
			
			local position = { x = chicken_data.x, y = chicken_data.y };
			actor:JumpToPoint(position);
			
			while actor.children == nil do
				delay(1);
			end
			
			local original_pos = actor:GetPosition();
			
			actor.pause = false;
			actor.moving = false;
			actor.chicken_data = chicken_data;			
		end;		
		
		on_click = function(flo, actor)
			globalFlo = flo;
			if ( songPlaying == false and mistake == false and comeBack == false and celebrating == false and transition == false and chicken_data.nest > 0 ) then
				Chicken_PlayAnim( actor, "DoTalkE" );
				sfx:PlaySFX( sounds[actor.note], false );	
				chickenItems[num].animationTime = CHICKEN_FLAP_TIME;
				
				local round = game:Get("mg_chickenchorus_activity_round");
				local song = game:Get("mg_chickenchorus_activity_num");
				local activity_mode = game:Get("activity_mode") == 1;
	
				if activity_mode then
					song = game:Get("activity_mode_level");
					round = table.getn(round_num);
				end
				
				if ( actor.note == song_table[round][song].notes[nextNote] ) then
					local noteIndex = GetNoteIndex( nextNote );
					lyricBarInfo[noteIndex].correct = true;					
					updateLyricBar( round, song, nextNote );
					if ( noteIndex == 7 ) then
						for i = 1, 7 do
							lyricBarInfo[i].correct = false;
						end
					end
					nextNote = nextNote + 1;					
					updateLyricBar( round, song, nextNote );	
				else
					lyricBarError( nextNote );
					--nextNote = 1;
				end																
			end
		end;
		
		point_at_fn = function(actor, enter)
			if scene["NEST_OVERLAY" .. chicken_data.nest] and actor:GetAlpha() > 0 then
				if ( songPlaying == false and mistake == false and comeBack == false and celebrating == false and transition == false and enter) then
					scene["NEST_OVERLAY" .. chicken_data.nest]:LoadImage("Nest_overlay" .. chicken_data.nest .. "a");
				else
					scene["NEST_OVERLAY" .. chicken_data.nest]:LoadImage("Nest_overlay" .. chicken_data.nest);
				end
			end
		end;
	}
end

function GetNoteIndex( note )
	local noteIndex = math.floor( fmod( nextNote, 7 ) );
	if ( noteIndex == 0 ) then
		noteIndex = 7;
	end
	return noteIndex;
end

function lyricBarError( note )	
	for i = 1, 7 do
		lyricBarInfo[i].correct = true;
	end
	mistake = true;
	local noteIndex = GetNoteIndex( note );
	Chicken_SetAlpha( lyricBarInfo[noteIndex].chicken1, 0 );
	Chicken_SetAlpha( lyricBarInfo[noteIndex].chicken2, 0 );
	lyricBarInfo[noteIndex].questionMark:SetAlpha( 0 );
	local offset = { x = lyricBarInfo[noteIndex].offset.x, y = lyricBarInfo[noteIndex].offset.y - 50 };
	errorHighlight:JumpToPoint( offset );
	errorHighlight:SetAlpha( 1 );
	hen:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	hen:PlayAnim( "Unhappy" );
	sfx:PlaySFX("audio/sfx/hen_negative");
	henAnimTime = 17;
	
	if henAnimTime < note then
		henAnimTime = note;
	end
end

function ColourChicken( chicken, data )
	chicken.children[1]:SetTint( data.wings_color ); 
	chicken.children[2]:SetTint( data.body_color ); 
	chicken.children[3]:SetTint( data.belly_color ); 
	chicken.children[4]:SetTint( data.tail_color ); 
end

function get_chicken_body_spec(num, chicken_data)
	return
	{
		name = "CHICKEN_BODY_" .. num;
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_body" };
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetWalkSpeed(chicken_speed);
			actor:SetDepthValue(chicken_data.y-1);
			
			if chicken_data.scale then
				actor:SetScaleX(chicken_data.scale.x);
			end
			
			prepare_actor_text(actor);
			
			local position = { x = chicken_data.x, y = chicken_data.y };
			actor:JumpToPoint(position);
			
			actor:SetTint(chicken_data.body_color);
		end;
	}
end

function get_chicken_belly_spec(num, chicken_data)
	return
	{
		name = "CHICKEN_BELLY_" .. num;
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_belly" };
		
		command = function(actor)			
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);			
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetWalkSpeed(chicken_speed);
			actor:SetDepthValue(chicken_data.y-1);
			
			if chicken_data.scale then
				actor:SetScaleX(chicken_data.scale.x);
			end
			
			prepare_actor_text(actor);
			
			local position = { x = chicken_data.x, y = chicken_data.y };
			actor:JumpToPoint(position);
			
			actor:SetTint(chicken_data.belly_color);
		end;
	}
end

function get_chicken_wings_spec(num, chicken_data)
	return
	{
		name = "CHICKEN_WINGS_" .. num;
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_wings" };
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetWalkSpeed(chicken_speed);
			actor:SetDepthValue(chicken_data.y-1);
			
			if chicken_data.scale then
				actor:SetScaleX(chicken_data.scale.x);
			end
			
			prepare_actor_text(actor);
			
			local position = { x = chicken_data.x, y = chicken_data.y };
			actor:JumpToPoint(position);
			
			actor:SetTint(chicken_data.wings_color);
		end;
	}
end

function get_chicken_tail_spec(num, chicken_data)
	return
	{
		name = "CHICKEN_TAIL_" .. num;
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_tail" };
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:SetWalkSpeed(chicken_speed);
			actor:SetDepthValue(chicken_data.y-1);
			
			if chicken_data.scale then
				actor:SetScaleX(chicken_data.scale.x);
			end
			
			prepare_actor_text(actor);
			
			local position = { x = chicken_data.x, y = chicken_data.y };
			actor:JumpToPoint(position);
			
			actor:SetTint(chicken_data.tail_color);
		end;
	}
end

function game_loop()
	while ( true ) do
		
		while activity_setup == false do
			delay(1);
		end
		activity_setup = false;
		stop_activity_timer();
		
		local activityNum = game:Get("mg_chickenchorus_activity_num");
		local activityRound = game:Get("mg_chickenchorus_activity_round");
		local activityMode = game:Get("activity_mode") == 1;
		local first_play_song = true;

		if activityMode then
			activityNum = game:Get("activity_mode_level");
			activityRound = table.getn(round_num);
		end
		
		request_song(activityNum);
		start_song();
		eggTextItem:LoadImage( eggTextInfo.stop_button );
		--eggTextItem:SayRaw( eggTextInfo.stop );
		local song = activityNum;
		note = 1;
		transition = false;
		while ( passed == false ) do	
			while ( mistake == true ) do
				if ( henAnimTime <= 0 ) then
					hen:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
					hen:PlayAnim( "DoStandW" );
					mistake = false;
					errorHighlight:SetAlpha( 0 );
					updateLyricBar( activityRound, song, nextNote );	
				end
				henAnimTime = henAnimTime - 1;
				delay( 5 );
				
				errorHighlight:SetAlpha( 0 );
				nextNote = math.max(1, nextNote - 1);
				updateLyricBar( activityRound, activityNum, nextNote );	
			end
			while ( songPlaying == true ) do
				if startDelay > 0 then
					delay(startDelay)
					startDelay = 0;
				end
				updateLyricBar( activityRound, song, note );		
				local chickenIndex = note2chicken[song_table[activityRound][song].notes[note]];				
				Chicken_PlayAnim( chickenItems[chickenIndex].item, "DoTalkE" );
				local nest = chickenItems[chickenIndex].item.chicken_data.nest;
				scene["NEST_OVERLAY" .. nest]:LoadImage("Nest_overlay" .. nest .. "a");
				chickenItems[chickenIndex].animationTime = 1;
				sfx:PlaySFX( sounds[song_table[activityRound][song].notes[note]], false );			
				for i = 1, 8 do
					if ( chickenItems[i].animationTime <= 0 ) then
						Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
						local nest = chickenItems[i].item.chicken_data.nest;
						scene["NEST_OVERLAY" .. nest]:LoadImage("Nest_overlay" .. nest);
					else				
						chickenItems[i].animationTime = chickenItems[i].animationTime - 1;
					end
				end
				delay( 25 );
				if ( note >= song_table[activityRound][song].numNotes ) then
					eggTextItem:LoadImage( eggTextInfo.button );
					stop_song();
				end
				note = note + 1;
				
				for i = 1, 8 do
					if ( chickenItems[i].animationTime <= 0 ) then
						Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
						local nest = chickenItems[i].item.chicken_data.nest;
						scene["NEST_OVERLAY" .. nest]:LoadImage("Nest_overlay" .. nest);
					else				
						chickenItems[i].animationTime = chickenItems[i].animationTime - 1;
					end
				end
				
				delay(5);
			end
			if first_play_song == true then
				first_play_song = false;
				if activityMode then
					start_activity_timer();
				end
			end
				
			delay( 1 );
			for i = 1, 8 do
				if ( chickenItems[i].animationTime <= 0 ) then
					Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
				else				
					chickenItems[i].animationTime = chickenItems[i].animationTime - 1;
				end
			end
		end	
		next_activity_pressed = false;
		transition = true;
		-- all chickens should flap wings and cluck when song completed
		if not activityMode then
			ShowEgg();
		end
		celebrating = true;
		for chickenIndex = 1, 8 do
			Chicken_PlayAnim( chickenItems[chickenIndex].item, "DoTalkE" );
			chickenItems[chickenIndex].animationTime = 80			
		end
		hen:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		hen:PlayAnim( "Happy" );
		sfx:PlaySFX("audio/sfx/hen_positive");
		local j = 0;
		stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
		while ( celebrating == true ) do				
			for i = 1, 8 do
				if ( chickenItems[i].animationTime <= 0 ) then
					Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
					celebrating = false;
					hen:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
					hen:PlayAnim( "DoStandW" );
				else				
					chickenItems[i].animationTime = chickenItems[i].animationTime - 1;					
				end				
			end			
			if ( j == 3 ) then
				sfx:PlaySFX( sounds[math.random(1,8)], false );	
				j = 0;
			else
				j = j + 1;			
			end			
			delay(1);
		end
		scene.FLO:StartProc(activity_passed);
		reset();		
		if ( game:Get("mg_chickenchorus_activity_round") ~= 1 and not activityMode ) then
			help_panel_say_raw(scene:grabstring("round_complete_1"));
			for i = 1, 8 do
				Chicken_PlayAnim( chickenItems[i].item, "NoMove" );
			end
		end
		
		while next_activity_pressed == false do		
			delay(1);
		end
		
		if not activityMode then
			if ( next_activity_pressed ) then
				transition = false;						
			end
			setup_activity();
		end
	end
end

function reset()
	nextNote = 1;
	passed = false;	
end

function setup_activity_initial()
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
			scene:Spawn(activity_title_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
		
		spawn_talkBar();
		spawn_chickens();		
		spawn_hen();		
		spawn_lyricBar();	
	else
	end
	
	if ( GetNumChickensFound() ~= 8 ) then
		HideChickens();
	end	
end;

function launch_activity()
	local activityMode = game:Get("activity_mode") == 1;
	if ( GetNumChickensFound() == 8 ) then
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
		game_loop();
	else
		comeBack = true;
		ComeBackLater();
	end	
end;

function setup_activity()
	local activityNum = game:Get("mg_chickenchorus_activity_num");
	local activityRound = game:Get("mg_chickenchorus_activity_round");
	local activityMode = game:Get("activity_mode") == 1;

	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if not activityMode then
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	end
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	if game:Get("activity_mode") == 1 then
		eggTextItem:SetAlpha(1);
		eggTextItem:LoadZone(eggTextInfo.button);
	end
	
	activity_setup = true;
end

function spawn_talkBar()
	comeBackTalkItem = scene:Spawn( get_comeBackTalk_spec( "comeBackTalk", comeBackTalkInfo.image, comeBackTalkInfo.offsetInactive ) );	
end

function HideChickens()
	for i = 1, 8 do
		if ( game:Get("mg_chickenfield_chicken_found_" .. tostring(i)) == 1 ) then
			Chicken_SetAlpha( chickenItems[i].item, 1 )
		else
			Chicken_SetAlpha( chickenItems[i].item, 0 )
		end
	end
end

function ComeBackLater()
	if game:Get("first_time_talked_to_hen") < 1 then
		scene.FLO:SetMode(MODE.CUTSCENE);
		--coroutine.yield(RESUME.ON_CLICK);
		run_super_conversation( scene.FLO, "barn_intro" );
		game:Set("first_time_talked_to_hen", 1);
		add_quest("pass_chickenfield", true, true);
		wait_subscene();
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	else
		scene.FLO:SetMode(MODE.CUTSCENE);
		run_super_conversation( scene.FLO, "barn_reentry" );
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	end
	
	comeBackTalkItem:JumpToPoint( comeBackTalkInfo.offset );
end

function GetNumChickensFound()
	local activityMode = game:Get("activity_mode") == 1;
	local chickens = 0;
	
	if activityMode then
		chickens = 8;
	else
		chickens = game:Get("mg_chickenfield_chicken_found_1") + 
					game:Get("mg_chickenfield_chicken_found_2") +
					game:Get("mg_chickenfield_chicken_found_3") +
					game:Get("mg_chickenfield_chicken_found_4") +
					game:Get("mg_chickenfield_chicken_found_5") +
					game:Get("mg_chickenfield_chicken_found_6") +
					game:Get("mg_chickenfield_chicken_found_7") +
					game:Get("mg_chickenfield_chicken_found_8");
	end
	
	if cheat then
		return 8;
	else
		return chickens;
	end
end

function next_activity(flo)
	next_activity_pressed = true;

	local activityNum = game:Get("mg_chickenchorus_activity_num");
	local activityRound = game:Get("mg_chickenchorus_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	if not activityMode and roundComplete then	
		goto_scene(flo, "m2_farm");	
	else
		if not activityMode then
			scene.NEXT_ACTIVITY_BUTTON:Expire();
		end
		
		if activityMode then
			spawn_button(start_button_spec);
			eggTextItem:SetAlpha(0);
			eggTextItem:DumpZone();
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
		else
			spawn_button(hint_button_spec);
			move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		end
		
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				spawn_button(fail_activity_button_spec);
			end
		end;
		
--		-- load new puzzle
--		setup_activity();
		if activityMode then
			kill_activity_timer();
		end
	end

end;

function activity_passed(flo)
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	local activityNum = game:Get("mg_chickenchorus_activity_num");
	local activityRound = game:Get("mg_chickenchorus_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;
	
	if IsCheatMode() then
		if not activityMode then
			scene.FAIL_ACTIVITY_BUTTON:Expire();
		end
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	if not activityMode then
		scene.HINT_BUTTON:Expire();
	end
	
	scene.BACK_BUTTON:Expire();
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
		if ( continueLocation == nil ) then
			continueLocation = scene.NEXT_ACTIVITY_BUTTON:GetPosition();
		end
		
		help_panel_say_raw(
			scene:grabstring("activity_complete_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		
		if roundComplete then	
			if activityRound == 1 then
				game:Set("mg_chickenchorus_activity_round", 2);
				game:Set("mg_chickenchorus_activity_num", 1);
			end
		else
			game:Set("mg_chickenchorus_activity_num", activityNum + 1);
		end
	end
	
	HideContinue();
	
	if not activityMode then
		HideEgg();
		GetEgg(flo);
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_pattern.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	ShowContinue();
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_chickenconductor");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/dom_casual_std.mvec",
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/dom_casual_std.mvec",
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/dom_casual_std.mvec",
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	passed = true;
end

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
		
	on_click = function(flo, actor)
		if ( comeBack == false ) then
			help_panel_say_raw(scene:grabstring("instructions"));
		else
			help_panel_say_raw( "我们需要去原野收集小鸡." );
		end
	end;
}

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m2_farm");
end;

function spawn_nest(_name, _depth)
	return scene:Spawn
	{
		name = string.upper(_name);
		gfx = { image = _name };
		
		command = function(actor)
			actor:SetDepthValue(_depth);
		end;
	};
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		sfx:KillMusic();
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		game:ClearInvUsage();
		
		fade_scene_up(true);
		
		if IsCheatMode() then
			-- testing data
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				spawn_button(fail_activity_button_spec);
			end
		end
		
		-- set up for initial play
		if game:Get("mg_chickenchorus_activity_num") < 1 then
			game:Set("mg_chickenchorus_activity_num", 1);
		end
		
		if game:Get("mg_chickenchorus_activity_round") < 1 then
			game:Set("mg_chickenchorus_activity_round", 1);
		end
		
		game:Set("visited_chicken_chorus", 1);
		
		-- unlock chicken chorus in activity mode
		if game:Get("chicken_chorus_unlocked") < 1 then
			game:Set("chicken_chorus_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		spawn_nest("Nest_overlay1", 200);
		spawn_nest("Nest_overlay2", 250);
		spawn_nest("Nest_overlay3", 400);
		spawn_nest("Nest_overlay4", 400);
		spawn_nest("Nest_overlay5", 250);
		spawn_nest("Nest_overlay6", 250);
		spawn_nest("Nest_overlay7", 400);
		spawn_nest("Nest_overlay8", 400);
		
		setup_activity_initial();
		
		lower_hud();
		
		if activityMode then
			spawn_button(start_button_spec);
			eggTextItem:SetAlpha(0);
			eggTextItem:DumpZone();
		else
			spawn_button(hint_button_spec);
		end
		
		spawn_help_panel(game:GetLastScene() == "mg_chickenfield");
		
		launch_activity();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST },
		
		{ "Nest_overlay0", 200 },
		
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		scene_setup,
	};
};
